/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.extension;

import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.extension.Extension;
import de.willuhn.jameica.messaging.MessageBus;
import de.willuhn.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtensionRegistry {
    private static Map<String, List<Extension>> extensions = new HashMap<String, List<Extension>>();

    public static void extend(Extendable extendable) {
        if (extendable == null) {
            return;
        }
        String id = extendable.getExtendableID();
        if (id == null) {
            return;
        }
        int count = 0;
        List<Extension> v = extensions.get(id);
        if (v != null) {
            for (Extension e : v) {
                try {
                    e.extend(extendable);
                    ++count;
                }
                catch (Throwable t) {
                    Logger.error((String)("error while extending " + id), (Throwable)t);
                }
            }
        }
        MessageBus.sendSync(id, count);
    }

    public static void register(Extension extension, String[] extendableIDs) {
        for (int i = 0; i < extendableIDs.length; ++i) {
            List<Extension> v = extensions.get(extendableIDs[i]);
            if (v == null) {
                v = new ArrayList<Extension>();
            }
            v.add(extension);
            extensions.put(extendableIDs[i], v);
        }
    }

    public static void register(Extension extension, String extendableID) {
        ExtensionRegistry.register(extension, new String[]{extendableID});
    }

    public static List<Extension> getExtensions(String extendableID) {
        return extensions.get(extendableID);
    }
}

